#include "MeetingServiceImpl.h"
#include "cmr/CMRControllerMgr.h"

#ifdef WIN32
#include "featuresets/Adapters/Dependence.h"
#include "sdkwrapper/win32/autoupgrade/jabber_sdk_wrap_impl.h"
#include "CalendarIntegration.h"
#else
#include "sdkwrapper/mac/InstantMessageMgr.h"
#include "sdkwrapper/mac/MeetingApiDelegate.h"
#include "sdkwrapper/mac/MeetingSDKWrap.h"
#endif

#include "JabberServiceProvider.h"
#include "MeetingServiceObjectManager.h"

namespace CSFUnified {        

#ifndef WIN32
    class JMLoggerImpl : public IJMLogger
#else
    class JMLoggerImpl : public JMLogger
#endif
    {
    public:
        JMLoggerImpl()
        {
            m_meetingSDKLogger = CSFLogger_getLogger("MeetingService-MeetingSDK");
        }
        virtual ~JMLoggerImpl()
        {
        }
        void log(int level, const char *sourceFile, int sourceLine, const char *function, const char *fmt, va_list args)
        {
            switch (level)
            {
            case JMLOG_ERROR:
                CSFLogV(m_meetingSDKLogger, CSF_LOG_ERROR, sourceFile, sourceLine, function, fmt, args);
                break;
            case JMLOG_WARNING:
                CSFLogV(m_meetingSDKLogger, CSF_LOG_WARNING, sourceFile, sourceLine, function, fmt, args);
                break;
            case JMLOG_INFO:
                CSFLogV(m_meetingSDKLogger, CSF_LOG_INFO, sourceFile, sourceLine, function, fmt, args);
                break;
            case JMLOG_DEBUG:
                if (CSFLog_isDebugEnabled(m_meetingSDKLogger))
                {
                    CSFLogV(m_meetingSDKLogger, CSF_LOG_DEBUG, sourceFile, sourceLine, function, fmt, args);
                }
                break;
            default:
                break;
            }
        }
    private:
        CSFLogger *m_meetingSDKLogger;
    };

    static CSFLogger *meetingServiceImplLogger = CSFLogger_getLogger("MeetingService-MeetingServiceImpl");

    MeetingServiceImpl::MeetingServiceImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory)
    : MeetingServiceBaseImpl(unifiedFactory)
    {
		CSFLogDebugS(meetingServiceImplLogger, "MeetingServiceImpl::MeetingServiceImpl");
		EnsureUpdateAccess();

		m_MeetingLogger.reset(new JMLoggerImpl());
#ifdef WIN32
		CDependence::getInstance()->SetUnifiedFactory(unifiedFactory);
		CDependence::getInstance()->GetJabberWerxCommonHelper()->InitHelper(unifiedFactory);
		JabberSDKWrapImpl::getInstance()->setUnifiedFactory(unifiedFactory);
		JabberSDKWrapImpl::getInstance()->setJMLogger(m_MeetingLogger.get());
#else
        InstantMessageMgr::getInstance()->setUnifiedFactory(unifiedFactory);
        MeetingSDKWrap::getInstance()->setUnifiedFactory(unifiedFactory);
        MeetingSDKWrap::getInstance()->setJMLogger(m_MeetingLogger.get());
#endif
    }
    
    MeetingServiceImpl::MeetingServiceImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory, bool offServicesDispatcher)
    : MeetingServiceBaseImpl(unifiedFactory, offServicesDispatcher)
    {
    }
    
    MeetingServiceImpl::~MeetingServiceImpl()
    {
#ifdef WIN32
		JabberSDKWrapImpl::getInstance()->setJMLogger(NULL);
#else
        MeetingSDKWrap::getInstance()->setJMLogger(NULL);
#endif
    }
        
    SMART_PTR_NS::shared_ptr<CSFUnified::MeetingMgrController> MeetingServiceImpl::getMeetingMgrController()
    {
        SMART_PTR_NS::shared_ptr<MeetingFeatureSet> meetingFS = this->unifiedFactory->getFeatureSet<MeetingFeatureSet>();
        return meetingFS->getMeetingMgrController();
    }
    
    SMART_PTR_NS::shared_ptr<CSFUnified::DesktopSharingController> MeetingServiceImpl::getDesktopSharingController()
    {
        SMART_PTR_NS::shared_ptr<MeetingFeatureSet> meetingFS = this->unifiedFactory->getFeatureSet<MeetingFeatureSet>();
        return meetingFS->getDesktopSharingController();
    }
    
    SMART_PTR_NS::shared_ptr<CSFUnified::MeetingAccountController> MeetingServiceImpl::getMeetingAccountController()
    {
        SMART_PTR_NS::shared_ptr<MeetingFeatureSet> meetingFS = this->unifiedFactory->getFeatureSet<MeetingFeatureSet>();
        return meetingFS->getMeetingAccountController();
    }
    
    SMART_PTR_NS::shared_ptr<CSFUnified::CMRController> MeetingServiceImpl::getCMRController(std::string JID)
    {
        SMART_PTR_NS::shared_ptr<MeetingFeatureSet> meetingFS = this->unifiedFactory->getFeatureSet<MeetingFeatureSet>();
        return meetingFS->getCMRController(JID);
    }

    void MeetingServiceImpl::registerCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback)
    {
        SMART_PTR_NS::shared_ptr<MeetingFeatureSet> meetingFS = this->unifiedFactory->getFeatureSet<MeetingFeatureSet>();
        return meetingFS->registerCMRMeetingCallback(callback);
    }
    
    void MeetingServiceImpl::unregisterCMRMeetingCallback(SMART_PTR_NS::shared_ptr<CSFUnified::CMRMeetingCallback> callback)
    {
        SMART_PTR_NS::shared_ptr<MeetingFeatureSet> meetingFS = this->unifiedFactory->getFeatureSet<MeetingFeatureSet>();
        return meetingFS->unregisterCMRMeetingCallback(callback);
    }    

    bool MeetingServiceImpl::isMeetingModuleEnabled()
    {
        JabberServiceProvider * pProvide = MeetingServiceObjectManager::getInstance().getJabberServiceProvider();
        if (NULL != pProvide)
        {
            return pProvide->isWbxMeetingEnabled();
        }
        else
        {
            return false;
        }
    }

    bool MeetingServiceImpl::isDesktopShareModuleEnable()
    {
        JabberServiceProvider * pProvide = MeetingServiceObjectManager::getInstance().getJabberServiceProvider();
        if (NULL != pProvide)
        {
            return !pProvide->isCupMode();
        }
        else
        {
            return false;
        }
    }

	CSFUnified::MailServiceTypeEnum::MailServiceType MeetingServiceImpl::getDefaultMailClient()
	{

#ifdef  WIN32

#define OUTLOOK_REGISTER_NAME	"microsoft outlook"
#define NOTES_REGISTER_NAME		"lotus notes"

		std::string strDefMail = CCalendarIntegration::GetDefaultMailClient();
		std::transform(strDefMail.begin(), strDefMail.end(), strDefMail.begin(), tolower);
		if (strDefMail.compare(OUTLOOK_REGISTER_NAME) == 0)
		{
			return CSFUnified::MailServiceTypeEnum::OUTLOOK;
		}
		else if (strDefMail.compare(NOTES_REGISTER_NAME) == 0)
		{
			return CSFUnified::MailServiceTypeEnum::LOTUS;
		}
		else
		{
			return CSFUnified::MailServiceTypeEnum::NONE;
		}
#else
		return CSFUnified::MailServiceTypeEnum::NONE;
#endif
	}

	void MeetingServiceImpl::loggedIn()
	{
#ifdef WIN32
		JabberServiceProvider * pProvider = MeetingServiceObjectManager::getInstance().getJabberServiceProvider();
		pProvider->startPresenceMonitor();
#endif
	}

	void MeetingServiceImpl::loggedOut()
	{
#ifdef WIN32
		JabberServiceProvider * pProvider = MeetingServiceObjectManager::getInstance().getJabberServiceProvider();
		pProvider->stopPresenceMonitor();
#endif
	}
}